 /* '01 Main.cpp' */

 /* Plik nagwka strumienia wejcia-wyjcia */
#include <iostream>
 /* Nagwek operacji na acuchach */
#include <string.h>

 /* Nasza klasa */
class CString
{
private:
 char              m_aString [1024];
public:
  /* Konstruktory */
 CString (void);
 CString (CString & rString);
 CString (char * pString);
  /* Destruktor */
 ~CString (void);

  /* Operatory */
 CString & operator = (CString & rString);
 CString & operator = (char * pString);
 bool operator == (CString & rString);
 bool operator == (char * pString);
 bool operator != (CString & rString);
 bool operator != (char * pString);

  /* Inne funkcje */
 char * GetString (void);
 int GetLength (void);
};

 /* Konstruktory */
CString::CString (void)
{
 m_aString [0] = '\0';
}

CString::CString (CString & rString)
{
 if (rString.GetLength () > 0)
 {
  strcpy (m_aString, rString.GetString ());
 }
 else
 {
  m_aString [0] = '\0';
 }
}

CString::CString (char * pString)
{
 if (pString)
 {
  strcpy (m_aString, pString);
 }
 else
 {
 m_aString [0] = '\0';
 }
}

 /* Destruktor */
CString::~CString (void)
{
 m_aString [0] = '\0';
}

 /* Operatory */
CString & CString::operator = (CString & rString)
{
 if (rString.GetLength () > 0)
 {
  strcpy (m_aString, rString.GetString ());
 }
 else
 {
 m_aString [0] = '\0';
 }

 return *this;
}

CString & CString::operator = (char * pString)
{
 if (pString)
 {
  strcpy (m_aString, pString);
 }
 else
 {
 m_aString [0] = '\0';
 }

 return *this;
}

bool CString::operator == (CString & rString)
{
 if (strcmp (rString.GetString (), m_aString) != 0)
 {
  return false;
 }
 else
 {
  return true;
 }
}

bool CString::operator == (char * pString)
{
 if (strcmp (pString, m_aString) != 0)
 {
  return false;
 }
 else
 {
  return true;
 }
}

bool CString::operator != (CString & rString)
{
 if (strcmp (rString.GetString (), m_aString) == 0)
 {
  return false;
 }
 else
 {
  return true;
 }
}

bool CString::operator != (char * pString)
{
 if (strcmp (pString, m_aString) == 0)
 {
  return false;
 }
 else
 {
  return true;
 }
}

  /* Inne funkcje */
char * CString::GetString (void)
{
 return m_aString;
}

int CString::GetLength (void)
{
 return strlen (m_aString);
}

 /* Start */
int main ()
{
  /* Uyj konstruktora */
 CString Test ("To tylko test!");
 CString Welcome;

  /* Uyj operatora przyporzdkowania */
 Welcome = "Witaj, swiecie!";

  /* Uyj acuchw */
 std::cout << Welcome.GetString () << std::endl;
 std::cout << Test.GetString () << std::endl;
 std::cout << "Welcome length: " << Welcome.GetLength () << std::endl;

  /* Uyj operatora porwnania */
 if (Welcome != Test)
 {
  std::cout << "'Welcome' jest rozne od 'Test'." << std::endl;
 }
 else
 {
  std::cout << "'Welcome' jest rowne 'Test'." << std::endl;
 }

 return 0;
}